<?php include_once 'header.php'; ?>

<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/izimodal/1.5.1/css/iziModal.min.css">
<link rel="stylesheet" type="text/css" href="assets/css/hobrt.css">

<style>
/* ==============================
   PRODUCT SHOW PAGE
============================== */
.hb-show-section {
	max-width: 1280px;
	margin: 0 auto;
	padding: 50px 24px 80px;
}

/* Alert message */
.hb-show-alert {
	background: linear-gradient(135deg, rgba(108,99,255,0.15), rgba(76,201,240,0.1));
	border: 1px solid var(--primary);
	border-radius: var(--radius);
	padding: 16px 20px;
	margin-bottom: 30px;
	color: var(--accent);
	font-weight: 600;
	display: flex;
	align-items: center;
	gap: 10px;
}

/* Product layout */
.hb-product-layout {
	display: grid;
	grid-template-columns: 1fr 1fr;
	gap: 50px;
	align-items: start;
}

/* === Image Gallery === */
.hb-gallery {
	position: sticky;
	top: 90px;
}
.hb-gallery-main {
	position: relative;
	border-radius: var(--radius);
	overflow: hidden;
	background: var(--dark-2);
	aspect-ratio: 1;
	margin-bottom: 14px;
	border: 1px solid var(--border);
	cursor: zoom-in;
}
.hb-gallery-main img {
	width: 100%; height: 100%;
	object-fit: cover;
	transition: transform 0.4s ease;
}
.hb-gallery-main:hover img { transform: scale(1.04); }

.hb-gallery-thumbs {
	display: grid;
	grid-template-columns: repeat(4, 1fr);
	gap: 10px;
}
.hb-gallery-thumb {
	border-radius: var(--radius-sm);
	overflow: hidden;
	border: 2px solid transparent;
	aspect-ratio: 1;
	background: var(--dark-2);
	cursor: pointer;
	transition: border-color var(--transition), transform var(--transition);
}
.hb-gallery-thumb img { width: 100%; height: 100%; object-fit: cover; }
.hb-gallery-thumb:hover,
.hb-gallery-thumb.active { border-color: var(--primary); transform: scale(1.03); }

/* === Product Info === */
.hb-product-details { padding-top: 4px; }

.hb-product-badge-row {
	display: flex;
	align-items: center;
	gap: 10px;
	margin-bottom: 14px;
	flex-wrap: wrap;
}
.hb-badge-new {
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	font-size: 0.72rem;
	font-weight: 800;
	padding: 4px 12px;
	border-radius: 6px;
	letter-spacing: 0.3px;
}
.hb-badge-sale {
	background: linear-gradient(135deg, var(--secondary), #b5179e);
	color: #fff;
	font-size: 0.72rem;
	font-weight: 800;
	padding: 4px 12px;
	border-radius: 6px;
}

.hb-product-name {
	font-size: clamp(1.3rem, 3vw, 2rem);
	font-weight: 900;
	line-height: 1.3;
	margin-bottom: 16px;
}

/* Discount + Price */
.hb-product-discount-info {
	display: flex;
	align-items: center;
	gap: 10px;
	margin-bottom: 8px;
}
.hb-discount-tag {
	background: rgba(247,37,133,0.1);
	border: 1px solid var(--secondary);
	color: var(--secondary);
	font-size: 0.82rem;
	font-weight: 700;
	padding: 4px 12px;
	border-radius: 8px;
}
.hb-product-price-row {
	display: flex;
	align-items: baseline;
	gap: 14px;
	margin-bottom: 24px;
}
.hb-price-main {
	font-size: 2rem;
	font-weight: 900;
	color: var(--accent);
}
.hb-price-strike {
	font-size: 1.1rem;
	color: var(--text-muted);
	text-decoration: line-through;
}

/* Divider */
.hb-divider {
	height: 1px;
	background: var(--border);
	margin: 20px 0;
}

/* Info text */
.hb-product-info-text {
	color: var(--text-muted);
	font-size: 0.9rem;
	line-height: 1.85;
	margin-bottom: 16px;
}
.hb-product-info-text p,
.hb-product-info-text ul { margin-bottom: 8px; }
.hb-product-info-text li { padding-right: 8px; }

/* Watching counter */
.hb-watching {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	background: rgba(76,201,240,0.08);
	border: 1px solid rgba(76,201,240,0.2);
	color: var(--accent);
	padding: 8px 16px;
	border-radius: 30px;
	font-size: 0.82rem;
	font-weight: 600;
	margin-bottom: 20px;
}
.hb-watching-dot {
	width: 8px; height: 8px;
	border-radius: 50%;
	background: var(--accent);
	animation: blink 1.5s ease-in-out infinite;
}
@keyframes blink {
	0%,100% { opacity: 1; }
	50%      { opacity: 0.3; }
}

/* Quantity */
.hb-qty-row {
	display: flex;
	align-items: center;
	gap: 14px;
	margin-bottom: 22px;
}
.hb-qty-label { font-size: 0.9rem; font-weight: 700; color: var(--text-muted); }
.hb-qty-ctrl {
	display: flex;
	align-items: center;
	gap: 0;
	border: 1px solid var(--border);
	border-radius: var(--radius-sm);
	overflow: hidden;
	background: var(--dark-2);
}
.hb-qty-ctrl .lx-minus,
.hb-qty-ctrl .lx-plus {
	width: 40px; height: 40px;
	display: flex; align-items: center; justify-content: center;
	font-size: 1.1rem;
	font-weight: 700;
	cursor: pointer;
	color: var(--text-muted);
	transition: background var(--transition), color var(--transition);
	user-select: none;
}
.hb-qty-ctrl .lx-minus:hover,
.hb-qty-ctrl .lx-plus:hover { background: var(--surface-hover); color: var(--text); }
.hb-qty-ctrl input#qty {
	width: 52px; height: 40px;
	border: none;
	border-left: 1px solid var(--border);
	border-right: 1px solid var(--border);
	background: transparent;
	color: var(--text);
	font-size: 1rem;
	font-weight: 700;
	text-align: center;
	outline: none;
}

/* Add to cart buttons */
.hb-add-btns { display: flex; flex-direction: column; gap: 12px; margin-bottom: 24px; }
.lx-add-to-cart {
	display: flex;
	align-items: center;
	justify-content: center;
	gap: 12px;
	padding: 16px 28px;
	border-radius: var(--radius);
	font-weight: 800;
	font-size: 1rem;
	background: linear-gradient(135deg, var(--primary), var(--secondary));
	color: #fff;
	cursor: pointer;
	box-shadow: 0 4px 20px rgba(108,99,255,0.35);
	transition: filter var(--transition), transform var(--transition);
}
.lx-add-to-cart:hover { filter: brightness(1.12); transform: translateY(-2px); }

/* Floating sticky btn for mobile */
.lx-purchase-btns-floating {
	display: none;
	position: fixed;
	bottom: 0; right: 0; left: 0;
	z-index: 500;
	padding: 14px 20px;
	background: rgba(15,14,23,0.95);
	backdrop-filter: blur(12px);
	border-top: 1px solid var(--border);
}

/* Share */
.hb-share {
	display: flex;
	align-items: center;
	gap: 10px;
	flex-wrap: wrap;
	margin-top: 4px;
}
.hb-share-label { font-size: 0.82rem; color: var(--text-muted); font-weight: 600; }
.hb-share a {
	width: 36px; height: 36px;
	border-radius: 10px;
	display: flex; align-items: center; justify-content: center;
	font-size: 0.9rem;
	transition: transform var(--transition), filter var(--transition);
	background: var(--surface);
	border: 1px solid var(--border);
}
.hb-share a:hover { transform: translateY(-3px); filter: brightness(1.3); }
.lx-facebook { color: #1877f2; }
.lx-twitter  { color: #1da1f2; }
.lx-whatsapp { color: #25d366; }

/* ==============================
   REVIEWS SECTION
============================== */
.hb-reviews-section {
	margin-top: 60px;
	padding-top: 50px;
	border-top: 1px solid var(--border);
}
.hb-reviews-header {
	display: flex;
	align-items: center;
	justify-content: space-between;
	flex-wrap: wrap;
	gap: 16px;
	margin-bottom: 30px;
}
.hb-add-review-btn {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	padding: 10px 22px;
	border-radius: var(--radius-sm);
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	font-weight: 700;
	font-size: 0.88rem;
	box-shadow: 0 4px 16px rgba(108,99,255,0.35);
	transition: filter var(--transition), transform var(--transition);
}
.hb-add-review-btn:hover { filter: brightness(1.15); transform: translateY(-2px); }

.hb-reviews-grid {
	display: grid;
	grid-template-columns: repeat(3, 1fr);
	gap: 18px;
}
.hb-review-card {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: var(--radius);
	padding: 20px;
	transition: border-color var(--transition);
}
.hb-review-card:hover { border-color: rgba(108,99,255,0.35); }
.hb-review-img {
	width: 60px; height: 60px;
	border-radius: 12px;
	object-fit: cover;
	margin-bottom: 12px;
	border: 2px solid var(--border);
}
.hb-review-name {
	font-weight: 700;
	font-size: 0.95rem;
	margin-bottom: 4px;
}
.hb-review-date {
	font-size: 0.75rem;
	color: var(--text-muted);
	margin-bottom: 10px;
}
/* Stars */
.rating {
	border: none;
	padding: 0;
	display: flex;
	flex-direction: row-reverse;
	gap: 2px;
	margin-bottom: 10px;
}
.rating input { display: none; }
.rating label {
	color: #444;
	font-size: 1.1rem;
	cursor: default;
}
.rating input:checked ~ label,
.rating label:hover ~ label,
.rating label:focus ~ label { color: #f59e0b; }
.hb-review-text {
	font-size: 0.85rem;
	color: var(--text-muted);
	line-height: 1.7;
}
.hb-review-admin-btns {
	display: flex;
	gap: 8px;
	margin-top: 12px;
}
.btn {
	display: inline-flex;
	align-items: center;
	gap: 6px;
	padding: 6px 14px;
	border-radius: 8px;
	font-size: 0.8rem;
	font-weight: 700;
	cursor: pointer;
	border: none;
	transition: filter var(--transition);
}
.btn:hover { filter: brightness(1.15); }
.red { background: rgba(247,37,133,0.15); color: var(--secondary); border: 1px solid var(--secondary); }
.green { background: rgba(76,201,240,0.12); color: var(--accent); border: 1px solid var(--accent); }

/* ==============================
   RELATED
============================== */
.hb-related-section { margin-top: 60px; }
.hb-related-grid {
	display: grid;
	grid-template-columns: repeat(4, 1fr);
	gap: 18px;
}
.hb-product-card { background: var(--dark-2); border: 1px solid var(--border); border-radius: var(--radius); overflow: hidden; transition: transform var(--transition), box-shadow var(--transition); }
.hb-product-card:hover { transform: translateY(-6px); box-shadow: var(--shadow); }
.hb-product-card a { display: block; color: inherit; }

/* ==============================
   REVIEW MODAL
============================== */
#modal-custom {
	display: none;
	position: fixed;
	inset: 0;
	z-index: 9999;
	background: rgba(0,0,0,0.85);
	backdrop-filter: blur(6px);
	align-items: center;
	justify-content: center;
	overflow-y: auto;
	padding: 30px;
}
#modal-custom.open { display: flex; }
#modal-custom section {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: 20px;
	padding: 36px;
	width: 100%;
	max-width: 500px;
	position: relative;
	animation: modalIn 0.3s ease;
}
@keyframes modalIn {
	from { opacity: 0; transform: scale(0.94) translateY(20px); }
	to   { opacity: 1; transform: scale(1) translateY(0); }
}
#modal-custom input,
#modal-custom textarea {
	width: 100%;
	background: var(--dark-3);
	border: 1px solid var(--border);
	border-radius: var(--radius-sm);
	padding: 12px 16px;
	color: var(--text);
	font-size: 0.95rem;
	margin-bottom: 14px;
	outline: none;
	transition: border-color var(--transition);
}
#modal-custom input:focus,
#modal-custom textarea:focus { border-color: var(--primary); }
#modal-custom textarea { height: 100px; resize: vertical; }
#modal-custom label {
	display: block;
	font-size: 0.85rem;
	color: var(--text-muted);
	font-weight: 600;
	margin-bottom: 8px;
}
#modal-custom footer {
	display: flex;
	gap: 12px;
	margin-top: 20px;
}
#modal-custom footer button {
	flex: 1;
	padding: 12px;
	border-radius: var(--radius-sm);
	font-weight: 700;
	font-size: 0.95rem;
	cursor: pointer;
	border: 1px solid var(--border);
	background: var(--surface);
	color: var(--text);
	transition: background var(--transition);
}
#modal-custom footer button:hover { background: var(--surface-hover); }
#modal-custom footer .submit {
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	border: none;
	box-shadow: 0 4px 16px rgba(108,99,255,0.35);
}
.icon-close {
	position: absolute;
	top: 16px; left: 16px;
	background: var(--surface);
	border: 1px solid var(--border);
	border-radius: 8px;
	width: 32px; height: 32px;
	display: flex; align-items: center; justify-content: center;
	cursor: pointer;
	font-size: 0.9rem;
	color: var(--text-muted);
	transition: background var(--transition), color var(--transition);
}
.icon-close:hover { background: var(--surface-hover); color: var(--text); }

/* Rating input (interactive) */
.rating-interactive {
	display: flex;
	flex-direction: row-reverse;
	gap: 6px;
	margin-bottom: 14px;
}
.rating-interactive input { display: none; }
.rating-interactive label {
	font-size: 1.6rem;
	color: #444;
	cursor: pointer;
	transition: color 0.15s;
}
.rating-interactive input:checked ~ label,
.rating-interactive label:hover,
.rating-interactive label:hover ~ label { color: #f59e0b; }

@media (max-width: 900px) {
	.hb-product-layout { grid-template-columns: 1fr; }
	.hb-gallery { position: static; }
	.hb-reviews-grid { grid-template-columns: 1fr 1fr; }
	.hb-related-grid { grid-template-columns: repeat(2, 1fr); }
	.lx-purchase-btns-floating { display: block; }
	.lx-purchase-btns { display: none; }
}
@media (max-width: 600px) {
	.hb-reviews-grid { grid-template-columns: 1fr; }
	.hb-related-grid { grid-template-columns: 1fr 1fr; }
}
</style>

<div class="hb-show-section">

	<?php if(isset($msg)): ?>
	<div class="hb-show-alert">
		<i class="fas fa-check-circle"></i>
		<?php echo $msg; ?>
	</div>
	<?php endif; ?>

	<?php foreach($info as $p) : ?>

	<div class="hb-product-layout">
		<!-- GALLERY -->
		<div class="hb-gallery">
			<div class="hb-gallery-main" id="hb-main-img-wrap">
				<img src="<?php echo base_url("uploads")."/" . add_thumb($p->images, "") ?>" data-nb="0" id="hb-main-img"/>
			</div>
			<div class="hb-gallery-thumbs">
				<?php
				$images = explode(",", $p->images);
				$i = 0;
				foreach($images as $img) { ?>
				<div class="hb-gallery-thumb <?php echo $i==0?'active':''; ?>" data-src="<?php echo base_url("uploads")."/" . add_thumb($img, ""); ?>" onclick="hbThumb(this)">
					<img src="<?php echo base_url("uploads")."/" . add_thumb($img, "_m") ?>" />
				</div>
				<?php $i++; } ?>
			</div>
		</div>

		<!-- INFO -->
		<div class="hb-product-details">
			<div class="hb-product-badge-row">
				<span class="hb-badge-new">جديد</span>
				<?php if($p->discount > 0): ?><span class="hb-badge-sale">خصم <?php echo $p->discount; ?>%</span><?php endif; ?>
			</div>

			<h1 class="hb-product-name"><?php echo $p->title; ?></h1>

			<?php if($p->discount > 0): ?>
			<div class="hb-product-discount-info">
				<span class="hb-discount-tag"><i class="fas fa-tag"></i> خصم <?php echo $p->discount; ?>%</span>
			</div>
			<div class="hb-product-price-row">
				<span class="hb-price-main"><?php echo floor($p->price - ($p->price * $p->discount / 100)); ?> DH</span>
				<span class="hb-price-strike"><?php echo $p->price; ?> DH</span>
			</div>
			<?php else: ?>
			<div class="hb-product-price-row">
				<span class="hb-price-main"><?php echo $p->price; ?> DH</span>
			</div>
			<?php endif; ?>

			<div class="hb-watching">
				<span class="hb-watching-dot"></span>
				<abbr><?php echo rand(100, 200); ?></abbr> شخص يشاهد هذا المنتوج حاليا
			</div>

			<div class="hb-divider"></div>

			<!-- Product short info -->
			<div class="hb-product-info-text"><?php echo nl2br($p->info); ?></div>
			<div class="hb-product-info-text"><?php echo nl2br($p->descr); ?></div>

			<div class="hb-divider"></div>

			<!-- Quantity -->
			<div class="hb-qty-row">
				<span class="hb-qty-label">الكمية:</span>
				<div class="hb-qty-ctrl">
					<span class="lx-minus">−</span>
					<input type="text" id="qty" name="qty" data-max="1000" value="1" />
					<span class="lx-plus">+</span>
				</div>
			</div>

			<!-- Add to Cart -->
			<div class="hb-add-btns lx-purchase-btns">
				<a href="javascript:;" class="lx-add-to-cart" data-id="<?php echo $p->id; ?>">
					<i class="fas fa-shopping-bag"></i>
					أطلب الآن
				</a>
			</div>

			<!-- Share -->
			<div class="hb-share">
				<span class="hb-share-label">شارك:</span>
				<a href="https://www.facebook.com/sharer/sharer.php?u=" class="popup lx-facebook" title="Facebook"><i class="fab fa-facebook-f"></i></a>
				<a href="https://twitter.com/intent/tweet?url=" class="popup lx-twitter" title="Twitter"><i class="fab fa-twitter"></i></a>
				<a href="whatsapp://send?text=" data-action="share/whatsapp/share" class="lx-whatsapp" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
			</div>
		</div>
	</div>

	<?php endforeach; ?>

	<!-- Floating Mobile CTA -->
	<div class="lx-purchase-btns-floating">
		<?php foreach($info as $p): ?>
		<a href="javascript:;" class="lx-add-to-cart" data-id="<?php echo $p->id; ?>">
			<i class="fas fa-shopping-bag"></i>
			أطلب الآن
		</a>
		<?php endforeach; ?>
	</div>

	<!-- Reviews Section -->
	<div class="hb-reviews-section">
		<div class="hb-reviews-header">
			<h2 style="font-size:1.4rem;font-weight:900;">آراء العملاء</h2>
			<a href="#" data-izimodal-open="#modal-custom" data-izimodal-transitionin="fadeInDown" class="hb-add-review-btn add_more">
				<i class="fas fa-star"></i>
				أضف تقييمك
			</a>
		</div>

		<div class="hb-reviews-grid">
			<?php foreach($votes as $vote) : ?>
			<div class="hb-review-card">
				<?php if(!empty($vote->img)): ?>
				<img src="reviews/<?php echo $vote->img; ?>" class="hb-review-img" alt="">
				<?php endif; ?>
				<div class="hb-review-name"><?php echo $vote->name; ?></div>
				<div class="hb-review-date"><i class="fas fa-calendar-alt" style="margin-left:4px;"></i>12/05/2019</div>
				<fieldset class="rating">
					<input type="radio" id="star5<?=$vote->id;?>" disabled value="5" <?php if($vote->vote == 5) echo "checked"; ?> /><label class="full" for="star5<?=$vote->id;?>">&#9733;</label>
					<input type="radio" id="star4<?=$vote->id;?>" disabled value="4" <?php if($vote->vote == 4) echo "checked"; ?> /><label class="full" for="star4<?=$vote->id;?>">&#9733;</label>
					<input type="radio" id="star3<?=$vote->id;?>" disabled value="3" <?php if($vote->vote == 3) echo "checked"; ?> /><label class="full" for="star3<?=$vote->id;?>">&#9733;</label>
					<input type="radio" id="star2<?=$vote->id;?>" disabled value="2" <?php if($vote->vote == 2) echo "checked"; ?> /><label class="full" for="star2<?=$vote->id;?>">&#9733;</label>
					<input type="radio" id="star1<?=$vote->id;?>" disabled value="1" <?php if($vote->vote == 1) echo "checked"; ?> /><label class="full" for="star1<?=$vote->id;?>">&#9733;</label>
				</fieldset>
				<p class="hb-review-text"><?php echo $vote->comment; ?></p>
				<?php if(is_login("admin_login")): ?>
				<div class="hb-review-admin-btns">
					<button class="btn red" onclick="delete_c(this, '<?=$vote->id;?>')"><i class="fa fa-remove"></i> حذف</button>
					<?php if($vote->ac == 0): ?>
					<button class="btn green" onclick="approve_c(this, '<?=$vote->id;?>')"><i class="fa fa-check"></i> موافقة</button>
					<?php endif; ?>
				</div>
				<?php endif; ?>
			</div>
			<?php endforeach; ?>
		</div>
	</div>

</div>

<!-- Review Modal -->
<div id="modal-custom">
	<button class="icon-close" onclick="document.getElementById('modal-custom').classList.remove('open')">×</button>
	<?php echo form_open_multipart(); ?>
	<section>
		<label>الإسم الكامل:</label>
		<input type="text" name="name" placeholder="أدخل إسمك الكامل" required>
		<label>صورة للمنتوج (اختياري):</label>
		<input type="file" name="img" accept="image/jpeg,image/png">
		<label>تعليقك:</label>
		<textarea name="comment" placeholder="شاركنا رأيك في المنتوج..."></textarea>
		<label>التقييم:</label>
		<div class="rating-interactive">
			<input type="radio" id="star5" name="starv" value="5" required /><label for="star5">&#9733;</label>
			<input type="radio" id="star4" name="starv" value="4" required /><label for="star4">&#9733;</label>
			<input type="radio" id="star3" name="starv" value="3" required /><label for="star3">&#9733;</label>
			<input type="radio" id="star2" name="starv" value="2" required /><label for="star2">&#9733;</label>
			<input type="radio" id="star1" name="starv" value="1" required /><label for="star1">&#9733;</label>
		</div>
		<footer>
			<button type="button" onclick="document.getElementById('modal-custom').classList.remove('open')">إلغاء</button>
			<button class="submit" type="submit">إرسال التقييم</button>
		</footer>
	</section>
	<?php echo form_close(); ?>
</div>

<?php include_once 'footer.php'; ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/izimodal/1.5.1/js/iziModal.min.js"></script>
<script src="https://unpkg.com/masonry-layout@4/dist/masonry.pkgd.min.js"></script>

<script type="text/javascript">
// Approve / delete review (preserved)
function approve_c(hada, id) {
	hadaj = $(hada);
	$.post(base_url + "/admin/approve_comment", {id : id}, function(data) {
		if(data == 1) { hadaj.remove(); }
	})
}
function delete_c(hada, id) {
	hadaj = $(hada);
	$.post(base_url + "/admin/delete_comment", {id : id}, function(data) {
		if(data == 1) { hadaj.closest('.hb-review-card').remove(); }
	})
}

// Gallery thumb switcher
function hbThumb(el) {
	document.querySelector('.hb-gallery-thumb.active').classList.remove('active');
	el.classList.add('active');
	document.getElementById('hb-main-img').src = el.dataset.src;
}

// Modal open from izimodal anchor
$(document).on('click', '.add_more', function(e) {
	e.preventDefault();
	document.getElementById('modal-custom').classList.add('open');
});

// iziModal init (for backward compatibility)
try { $("#modal-custom").iziModal(); } catch(e) {}
</script>