<?php include_once 'header.php'; ?>

<style>
.hb-thanks-section {
	display: flex;
	align-items: center;
	justify-content: center;
	min-height: calc(100vh - 70px);
	padding: 60px 24px;
}
.hb-thanks-card {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: 24px;
	padding: 60px 48px;
	text-align: center;
	max-width: 540px;
	width: 100%;
	position: relative;
	overflow: hidden;
	box-shadow: var(--shadow);
}
.hb-thanks-card::before {
	content: '';
	position: absolute;
	inset: 0;
	background:
		radial-gradient(circle at 30% 20%, rgba(108,99,255,0.12) 0%, transparent 50%),
		radial-gradient(circle at 70% 80%, rgba(76,201,240,0.08) 0%, transparent 50%);
	pointer-events: none;
}

/* Animated check */
.hb-thanks-icon {
	width: 90px; height: 90px;
	background: linear-gradient(135deg, var(--primary), #4cc9f0);
	border-radius: 50%;
	display: flex; align-items: center; justify-content: center;
	margin: 0 auto 28px;
	font-size: 2.5rem;
	color: #fff;
	box-shadow: 0 8px 30px rgba(108,99,255,0.45);
	animation: popIn 0.5s cubic-bezier(0.175,0.885,0.32,1.375) both;
}
@keyframes popIn {
	from { opacity: 0; transform: scale(0.5); }
	to   { opacity: 1; transform: scale(1); }
}

/* Confetti particles */
.hb-confetti span {
	position: absolute;
	width: 10px; height: 10px;
	border-radius: 2px;
	animation: confettiFall 2.5s ease forwards;
	opacity: 0;
}
@keyframes confettiFall {
	0%   { opacity: 1; transform: translateY(-10px) rotate(0deg); }
	100% { opacity: 0; transform: translateY(200px) rotate(720deg); }
}

.hb-thanks-badge {
	display: inline-flex;
	align-items: center;
	gap: 6px;
	background: rgba(108,99,255,0.1);
	border: 1px solid rgba(108,99,255,0.3);
	color: var(--primary);
	font-size: 0.78rem;
	font-weight: 700;
	padding: 5px 14px;
	border-radius: 30px;
	margin-bottom: 18px;
}

.hb-thanks-card h1 {
	font-size: clamp(1.5rem, 3vw, 2rem);
	font-weight: 900;
	margin-bottom: 14px;
	line-height: 1.3;
}
.hb-thanks-card p {
	color: var(--text-muted);
	font-size: 0.95rem;
	line-height: 1.8;
	margin-bottom: 32px;
}

/* Steps */
.hb-thanks-steps {
	display: flex;
	justify-content: center;
	gap: 24px;
	margin-bottom: 36px;
}
.hb-step {
	display: flex;
	flex-direction: column;
	align-items: center;
	gap: 8px;
	flex: 1;
	max-width: 110px;
}
.hb-step-icon {
	width: 44px; height: 44px;
	border-radius: 12px;
	background: var(--dark-3);
	border: 1px solid var(--border);
	display: flex; align-items: center; justify-content: center;
	font-size: 1.1rem;
	color: var(--primary);
}
.hb-step span {
	font-size: 0.72rem;
	font-weight: 600;
	color: var(--text-muted);
	text-align: center;
	line-height: 1.3;
}

.hb-thanks-btn {
	display: inline-flex;
	align-items: center;
	gap: 10px;
	padding: 14px 30px;
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	border-radius: 14px;
	font-weight: 800;
	font-size: 0.95rem;
	box-shadow: 0 4px 20px rgba(108,99,255,0.35);
	transition: filter var(--transition), transform var(--transition);
}
.hb-thanks-btn:hover { filter: brightness(1.12); transform: translateY(-2px); }

/* Confetti colors */
.c1 { background: #6c63ff; top: 20%; right: 15%; animation-delay: 0.1s; }
.c2 { background: #f72585; top: 10%; right: 40%; animation-delay: 0.3s; width: 6px; height: 14px; }
.c3 { background: #4cc9f0; top: 15%; left: 20%; animation-delay: 0.5s; }
.c4 { background: #f59e0b; top: 5%;  left: 50%; animation-delay: 0.2s; width: 14px; height: 6px; }
.c5 { background: #4ade80; top: 25%; left: 10%; animation-delay: 0.4s; border-radius: 50%; }

@media (max-width: 500px) {
	.hb-thanks-card { padding: 40px 24px; }
	.hb-thanks-steps { flex-direction: column; align-items: center; }
}
</style>

<div class="hb-thanks-section">
	<div class="hb-thanks-card">
		<!-- Confetti -->
		<div class="hb-confetti">
			<span class="c1"></span>
			<span class="c2"></span>
			<span class="c3"></span>
			<span class="c4"></span>
			<span class="c5"></span>
		</div>

		<div class="hb-thanks-icon">
			<i class="fas fa-check"></i>
		</div>

		<div class="hb-thanks-badge">
			<i class="fas fa-shield-alt"></i>
			تم التأكيد
		</div>

		<h1>شكراً لك على طلبكم! 🎉</h1>
		<p>
			لقد تم تسجيل طلبكم بنجاح.<br>
			سنقوم بالاتصال بكم في أقل من 24 ساعة لتأكيد الطلب.<br>
			شكراً لثقتكم بنا!
		</p>

		<!-- Steps -->
		<div class="hb-thanks-steps">
			<div class="hb-step">
				<div class="hb-step-icon"><i class="fas fa-clipboard-check"></i></div>
				<span>تم الطلب</span>
			</div>
			<div class="hb-step">
				<div class="hb-step-icon"><i class="fas fa-phone-alt"></i></div>
				<span>تأكيد هاتفي</span>
			</div>
			<div class="hb-step">
				<div class="hb-step-icon"><i class="fas fa-shipping-fast"></i></div>
				<span>التوصيل</span>
			</div>
		</div>

		<a href="<?php echo base_url(); ?>" class="hb-thanks-btn lx-cart-thanks-btns">
			<i class="fas fa-shopping-bag"></i>
			إكمال التسوق
		</a>
	</div>
</div>

<?php include_once 'footer.php'; ?>