<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
	<title>لوحة التحكم - تسجيل الدخول</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;900&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.1/css/all.css" integrity="sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP" crossorigin="anonymous">

	<style>
	* { box-sizing: border-box; margin: 0; padding: 0; }

	body {
		font-family: 'Cairo', sans-serif;
		background: #0a0914;
		color: #fffffe;
		direction: rtl;
		overflow: hidden;
		min-height: 100vh;
		display: flex;
		align-items: center;
		justify-content: center;
	}

	/* ---- Animated Background ---- */
	.hbl-bg {
		position: fixed;
		inset: 0;
		z-index: 0;
		overflow: hidden;
	}
	.hbl-bg-grad {
		position: absolute;
		inset: 0;
		background:
			radial-gradient(ellipse at 15% 50%, rgba(108,99,255,0.25) 0%, transparent 55%),
			radial-gradient(ellipse at 85% 30%, rgba(247,37,133,0.18) 0%, transparent 50%),
			radial-gradient(ellipse at 50% 100%, rgba(76,201,240,0.12) 0%, transparent 50%);
	}

	/* Floating blobs */
	.blob {
		position: absolute;
		border-radius: 50%;
		filter: blur(80px);
		opacity: 0.45;
		animation: blobFloat 8s ease-in-out infinite alternate;
	}
	.blob-1 { width: 420px; height: 420px; background: rgba(108,99,255,0.5); top: -100px; right: -80px; animation-duration: 9s; }
	.blob-2 { width: 300px; height: 300px; background: rgba(247,37,133,0.4); bottom: -60px; left: -60px; animation-duration: 7s; animation-delay: -3s; }
	.blob-3 { width: 200px; height: 200px; background: rgba(76,201,240,0.35); top: 40%; left: 30%; animation-duration: 11s; animation-delay: -6s; }
	@keyframes blobFloat {
		from { transform: translate(0, 0) scale(1); }
		to   { transform: translate(30px, 20px) scale(1.07); }
	}

	/* Grid overlay */
	.hbl-bg-grid {
		position: absolute;
		inset: 0;
		background-image:
			linear-gradient(rgba(255,255,255,0.025) 1px, transparent 1px),
			linear-gradient(90deg, rgba(255,255,255,0.025) 1px, transparent 1px);
		background-size: 50px 50px;
	}

	/* ---- Login Card ---- */
	.hbl-card {
		position: relative;
		z-index: 1;
		width: 100%;
		max-width: 440px;
		padding: 48px 42px;
		margin: 0 24px;
		background: rgba(20,18,34,0.75);
		backdrop-filter: blur(20px);
		-webkit-backdrop-filter: blur(20px);
		border: 1px solid rgba(255,255,255,0.1);
		border-radius: 24px;
		box-shadow:
			0 20px 60px rgba(0,0,0,0.5),
			inset 0 1px 0 rgba(255,255,255,0.07);
		animation: cardIn 0.5s cubic-bezier(0.175,0.885,0.32,1.275) both;
	}
	@keyframes cardIn {
		from { opacity: 0; transform: translateY(40px) scale(0.95); }
		to   { opacity: 1; transform: translateY(0) scale(1); }
	}

	/* Card Header */
	.hbl-card-icon {
		width: 72px; height: 72px;
		background: linear-gradient(135deg, #6c63ff, #f72585);
		border-radius: 20px;
		display: flex;
		align-items: center;
		justify-content: center;
		font-size: 1.8rem;
		color: #fff;
		margin: 0 auto 22px;
		box-shadow: 0 8px 28px rgba(108,99,255,0.5);
		animation: iconPop 0.6s 0.3s cubic-bezier(0.175,0.885,0.32,1.375) both;
	}
	@keyframes iconPop {
		from { opacity: 0; transform: scale(0.6); }
		to   { opacity: 1; transform: scale(1); }
	}
	.hbl-card h1 {
		text-align: center;
		font-size: 1.5rem;
		font-weight: 900;
		margin-bottom: 6px;
	}
	.hbl-card p.hbl-sub {
		text-align: center;
		font-size: 0.82rem;
		color: rgba(255,255,255,0.45);
		margin-bottom: 32px;
	}

	/* Error message */
	.hbl-error {
		background: rgba(247,37,133,0.1);
		border: 1px solid rgba(247,37,133,0.4);
		border-radius: 10px;
		padding: 12px 16px;
		font-size: 0.85rem;
		color: #f72585;
		margin-bottom: 20px;
		display: flex;
		align-items: center;
		gap: 10px;
	}

	/* Form */
	form { }
	.hbl-input-group {
		position: relative;
		margin-bottom: 16px;
	}
	.hbl-input-group i {
		position: absolute;
		top: 50%; right: 16px;
		transform: translateY(-50%);
		color: rgba(255,255,255,0.35);
		font-size: 0.9rem;
		transition: color 0.2s;
		pointer-events: none;
	}
	.hbl-input-group:focus-within i { color: #6c63ff; }
	.hbl-input-group input {
		width: 100%;
		background: rgba(255,255,255,0.06);
		border: 1px solid rgba(255,255,255,0.1);
		border-radius: 12px;
		padding: 14px 46px 14px 16px;
		font-size: 0.95rem;
		font-family: 'Cairo', sans-serif;
		color: #fffffe;
		outline: none;
		transition: border-color 0.25s, background 0.25s;
	}
	.hbl-input-group input::placeholder { color: rgba(255,255,255,0.3); }
	.hbl-input-group input:focus {
		border-color: #6c63ff;
		background: rgba(108,99,255,0.1);
	}

	/* Submit */
	button#login-button {
		width: 100%;
		padding: 15px;
		border-radius: 12px;
		background: linear-gradient(135deg, #6c63ff, #f72585);
		color: #fff;
		font-family: 'Cairo', sans-serif;
		font-size: 1rem;
		font-weight: 800;
		border: none;
		cursor: pointer;
		margin-top: 6px;
		box-shadow: 0 4px 20px rgba(108,99,255,0.45);
		transition: filter 0.25s, transform 0.25s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 10px;
	}
	button#login-button:hover { filter: brightness(1.12); transform: translateY(-2px); }
	button#login-button:active { transform: translateY(0); }

	/* Footer note */
	.hbl-note {
		text-align: center;
		font-size: 0.75rem;
		color: rgba(255,255,255,0.25);
		margin-top: 22px;
	}

	@media (max-width: 480px) {
		.hbl-card { padding: 36px 28px; }
	}
	</style>
</head>
<body>

<!-- Animated Background -->
<div class="hbl-bg">
	<div class="hbl-bg-grad"></div>
	<div class="blob blob-1"></div>
	<div class="blob blob-2"></div>
	<div class="blob blob-3"></div>
	<div class="hbl-bg-grid"></div>
</div>

<!-- Login Card -->
<div class="hbl-card">
	<div class="hbl-card-icon">
		<i class="fas fa-shield-alt"></i>
	</div>

	<h1>لوحة التحكم</h1>
	<p class="hbl-sub">أدخل بياناتك للوصول إلى المنصة</p>

	<?php if(isset($msg)): ?>
	<div class="hbl-error">
		<i class="fas fa-exclamation-triangle"></i>
		<?php echo $msg; ?>
	</div>
	<?php endif; ?>

	<form class="form" action="" method="post">
		<div class="hbl-input-group">
			<i class="fas fa-user"></i>
			<input type="text" placeholder="إسم المستخدم" name="u" autocomplete="username">
		</div>
		<div class="hbl-input-group">
			<i class="fas fa-lock"></i>
			<input type="password" placeholder="كلمة السر" name="p" autocomplete="current-password">
		</div>
		<button type="submit" id="login-button">
			<i class="fas fa-sign-in-alt"></i>
			تسجيل الدخول
		</button>
	</form>

	<p class="hbl-note">نظام إدارة هو خاص بالمشرفين فقط</p>
</div>

</body>
</html>